;
;***********************
;        DEMO LCD      *
;      EXPERIMENT 0AH  *
;***********************
;
        CPU  "8085.TBL"
        HOF  "INT8"
;
        ORG  2100H

WR_COMM:   EQU  0ACH          ;LCD command port write
RD_COMM:   EQU  0ADH          ;LCD command port read
WR_DAT:    EQU  0AEH          ;LCD data port write
DELAY:     EQU  0FH
SYSCAL:    EQU  2
;
;
START:  MVI  A,38H            ;Function set
        CALL LCD_COM
        MVI  A,0FH            ;Display on/off control
        CALL LCD_COM
        MVI  A,6              ;Entrey mode set
        CALL LCD_COM
        MVI  A,1              ;Clear LCD
        CALL LCD_COM

        LXI  H,TAB1
        CALL BLOCKI
        MVI  A,4              ;cursor dec
        CALL LCD_COM

        MVI  A,0C0H+19
        CALL LCD_COM
        LXI  H,TAB2+19
        CALL BLOCKD
        MVI  B,0
        MVI  A,DELAY
        RST  SYSCAL
;
        MVI  A,7              ;address inc
        CALL LCD_COM
        MVI  C,40             ;shift 2 screen
;
START1: MVI  A,1CH            ;shift right
        CALL LCD_COM
        MVI  A,DELAY
        MVI  B,80H
        RST  SYSCAL
        DCR  C
        JNZ  START1
;
        MVI  B,0
        MVI  A,DELAY
        RST  SYSCAL
;
        MVI  A,5             ;address dec
        CALL LCD_COM
        MVI  C,40
;
START2: MVI  A,18H           ;shift left
        CALL LCD_COM
        MVI  A,DELAY
        MVI  B,80H
        RST  SYSCAL
        DCR  C
        JNZ  START2
        JMP  START
;
;***********************
;    SUB ROUTINE LCD   *
;***********************
;/* write command */
;  I/P = A
;
LCD_COM:
        CALL BUSY
        OUT  WR_COMM
        RET
;
;/* write ascii of LCD */
;  I/P = D
;
WR_ASCII:
        CALL BUSY
        MOV  A,D
        OUT  WR_DAT
        RET
;
;/* read busy flag */

BUSY:   PUSH PSW
BUSY1:  IN   RD_COMM
        ANI  80H
        JNZ  BUSY1
        POP  PSW
        RET
;
;***********************
;   WRITE DATA IN (HL) *
;***********************

BLOCK:  MOV  D,M
        CALL WR_ASCII
        MVI  B,40H
        MVI  A,DELAY
        RST  SYSCAL
        RET
;
;***********************
;    WRITE BLOCK INC   *
;***********************
;
BLOCKI: MVI  E,20
BLO_I1: CALL BLOCK
        INX  H
        DCR  E
        JNZ  BLO_I1
        RET
;
;***********************
;    WRITE BLOCK DEC   *
;***********************
;
BLOCKD: MVI  E,20
BLO_D1: CALL BLOCK
        DCX  H
        DCR  E
        JNZ  BLO_D1
        RET
;
TAB1:      DFB  "*LCD-20__CHARACTERS*"
TAB2:      DFB  "demo use instruction"
           END

